/*
 * Decompiled with CFR 0.152.
 */
package fr.asip.cps3.exemple.modele.objets;

import fr.asip.cps3.exemple.modele.exceptions.ExceptionObjet;
import fr.asip.cps3.exemple.modele.traitements.util.TraitementsUtil;
import iaik.pkcs.pkcs11.wrapper.CK_SESSION_INFO;
import iaik.pkcs.pkcs11.wrapper.PKCS11;
import iaik.pkcs.pkcs11.wrapper.PKCS11Exception;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class Session {
    private static Logger log = Logger.getLogger(Session.class);
    private long idSession;
    private String idToken;
    CK_SESSION_INFO info;
    Date dateOuverture;

    public Session(PKCS11 pKCS11, String string, long l) throws ExceptionObjet {
        this.idToken = string;
        this.idSession = l;
        this.dateOuverture = new Date();
        this.chargeInfo(pKCS11);
    }

    public void chargeInfo(PKCS11 pKCS11) throws ExceptionObjet {
        if (pKCS11 != null) {
            try {
                this.info = pKCS11.C_GetSessionInfo(this.idSession);
            }
            catch (PKCS11Exception pKCS11Exception) {
                log.error((Object)("Une erreur est survenue lors de la recuperation des informations de la session : " + TraitementsUtil.retranscritCodeRetour(pKCS11Exception.getErrorCode())));
                throw new ExceptionObjet(204, "Une erreur est survenue lors de la r\u00e9cuperation des informations de la session", pKCS11Exception);
            }
        } else {
            log.error((Object)"La librairie est nulle");
            throw new ExceptionObjet(204, "La librairie est nulle");
        }
    }

    public String getLibelle() {
        String string = "Session " + this.idSession;
        if (this.info != null) {
            string = string + " (";
            long l = this.info.state;
            if (l == 0L) {
                string = string + "RO public";
            } else if (l == 1L) {
                string = string + "RO utilisateur";
            } else if (l == 2L) {
                string = string + "RW public";
            } else if (l == 4L) {
                string = string + "RW SO";
            } else if (l == 3L) {
                string = string + "RW utilisateur";
            }
            try {
                string = string + "/Slot " + Long.toString(this.getIdSlot());
            }
            catch (ExceptionObjet exceptionObjet) {
                // empty catch block
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd hh:mm:ss");
            string = string + "/" + simpleDateFormat.format(this.dateOuverture);
            string = string + ")";
        }
        return string;
    }

    public long getIdSession() {
        return this.idSession;
    }

    public String getIdToken() {
        return this.idToken;
    }

    public long getIdSlot() throws ExceptionObjet {
        if (this.info != null) {
            return this.info.slotID;
        }
        log.error((Object)"Les informations de la session sont nulles, l'identifiant du slot est indisponible");
        throw new ExceptionObjet(204, "L'identifiant du slot est indisponible");
    }

    public boolean isSessionLectureSeuleNonLoguee() throws ExceptionObjet {
        if (this.info != null) {
            long l = this.info.state;
            return (l & 0L) != 0L;
        }
        log.error((Object)"Les informations de la session sont nulles, l'information sur la session est indisponible");
        throw new ExceptionObjet(204, "L'information sur la session est indisponible");
    }

    public boolean isSessionLectureSeuleLogueeUtilisateur() throws ExceptionObjet {
        if (this.info != null) {
            long l = this.info.state;
            return (l & 1L) != 0L;
        }
        log.error((Object)"Les informations de la session sont nulles, l'information sur la session est indisponible");
        throw new ExceptionObjet(204, "L'information sur la session est indisponible");
    }

    public boolean isSessionLectureEcritureLogueeSO() throws ExceptionObjet {
        if (this.info != null) {
            long l = this.info.state;
            return (l & 4L) != 0L;
        }
        log.error((Object)"Les informations de la session sont nulles, l'information sur la session est indisponible");
        throw new ExceptionObjet(204, "L'information sur la session est indisponible");
    }

    public boolean isSessionLectureEcritureLogueeUtilisateur() throws ExceptionObjet {
        if (this.info != null) {
            long l = this.info.state;
            return (l & 3L) != 0L;
        }
        log.error((Object)"Les informations de la session sont nulles, l'information sur la session est indisponible");
        throw new ExceptionObjet(204, "L'information sur la session est indisponible");
    }

    public long getEtatSession() throws ExceptionObjet {
        if (this.info != null) {
            return this.info.state;
        }
        log.error((Object)"Les informations de la session sont nulles, l'information sur l'\u00e9tat de la session est indisponible");
        throw new ExceptionObjet(204, "L'information sur l'\u00e9tat de la session est indisponible");
    }

    public String toString() {
        return this.getLibelle();
    }
}

